<?php

use App\Http\Controllers\Auth\AuthController;
use App\Http\Controllers\Config\ConfigController;
use App\Http\Controllers\Document\DocumentController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\Report\ReportController;
use App\Http\Controllers\StatusPipeline\StatusPipelineController;
use App\Http\Controllers\User\UserController;
use App\Http\Controllers\Venue\VenueController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/
Route::get("/", [HomeController::class, "index"])->name("home")->middleware(['auth']);
Route::middleware('guest')->group(function () {
    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
});

Route::middleware(['auth', 'role:superadmin|admin'])->group(function () {

    Route::get('user/{id}/password/update', [UserController::class, 'showPasswordUpdate'])
        ->name('user.password.show.update');
    Route::post('user/{id}/password', [UserController::class, 'updatePassword'])
        ->name('user.password.update');


    Route::prefix('status_pipelines')->group(function () {
        Route::post('/', [StatusPipelineController::class, 'store']);

        Route::put('/reorder', [StatusPipelineController::class, 'reorder'])
            ->name('status_pipelines.reorder');

        Route::put('/{status_pipeline}', [StatusPipelineController::class, 'update']);
        Route::delete('/{status_pipeline}', [StatusPipelineController::class, 'destroy']);
    });

    Route::prefix('venues')->group(function () {
        Route::post('/', [VenueController::class, 'store']);

        Route::put('/{venue_id}', [VenueController::class, 'update']);
        Route::delete('/{venue_id}', [VenueController::class, 'destroy']);
    });

    Route::prefix('reports')->name('reports.')->group(function () {
        Route::get('/', [ReportController::class, 'index'])->name('index');
    });
});
Route::middleware(['auth'])->group(function () {
    Route::get('config', [ConfigController::class, 'index'])
        ->name('config.index');

    Route::get('/documents/{document}/download', [DocumentController::class, 'download'])
        ->name('documents.download');

    Route::get('/documents/{lead_id}/download-all-lead', [DocumentController::class, 'downloadAllDocuments'])
        ->name('documents.download-all-lead');

    Route::prefix('ajax/widgets')->name('ajax.widgets.')
        ->middleware('throttle:widgets')
        ->group(function () {

            Route::get('/total-sales', [HomeController::class, 'getTotalSales'])
                ->name('total-sales');

            Route::get('/lead-type-stats', [HomeController::class, 'getLeadTypeStats'])
                ->name('lead-types');

            Route::get('/monthly-events', [HomeController::class, 'getMonthlyEvents'])
                ->name('monthly-events');

            Route::get('/total-leads', [HomeController::class, 'getTotalLeads'])
                ->name('total-leads');
        });
});

Route::post('/login', [AuthController::class, 'login'])->name('login.perform');
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');