<?php
use App\Http\Controllers\Superadmin\DepartmentController;
use App\Http\Controllers\Superadmin\TypeLeadController;
use Illuminate\Support\Facades\Route;


Route::prefix('superadmin')
    ->name('superadmin.')
    ->middleware(['auth', 'role:superadmin'])
    ->group(function () {
        Route::prefix('departments')->name('departments.')->group(function () {
            Route::get('/', [DepartmentController::class, 'index'])->name('index');
            Route::get('/create', [DepartmentController::class, 'create'])->name('create');
            Route::get('/{id}/edit', [DepartmentController::class, 'edit'])->name('edit');
 
            Route::post('/', [DepartmentController::class, 'store'])->name('store');
            Route::put('/{id}', [DepartmentController::class, 'update'])->name('update');
            Route::delete('/{id}', [DepartmentController::class, 'destroy'])->name('destroy');
        });
        Route::prefix('leadtypes')->name('leadtypes.')->group(function () {
            Route::get('/', [TypeLeadController::class, 'index'])->name('index');
            Route::get('/create', [TypeLeadController::class, 'create'])->name('create');
            Route::get('/{id}/edit', [TypeLeadController::class, 'edit'])->name('edit');

            Route::post('/', [TypeLeadController::class, 'store'])->name('store');
            Route::put('/{id}', [TypeLeadController::class, 'update'])->name('update');
            Route::delete('/{id}', [TypeLeadController::class, 'destroy'])->name('destroy');
        });
    });