<?php
use App\Http\Controllers\Admin\StaftController;
use Illuminate\Support\Facades\Route;


Route::prefix('admin')
    ->name('admin.')
    ->middleware(['auth'])
    ->group(function () {
        Route::prefix('stafts')->name('stafts.')->group(function () {
            Route::get('/', [StaftController::class, 'index'])->name('index');
            Route::get('/create', [StaftController::class, 'create'])->name('create');
            Route::get('/{id}/edit', [StaftController::class, 'edit'])->name('edit');
 
            Route::post('/', [StaftController::class, 'store'])->name('store');
            Route::put('/{id}', [StaftController::class, 'update'])->name('update');
            // Route::delete('/{id}', [DepartmentController::class, 'destroy'])->name('destroy');
        });
    });