<?php

namespace App\Services;

use App\DTOs\Report\FilterReportLeadsDTO;
use App\Http\Resources\Report\LeadReportResource;
use App\Queries\LeadFilterReportQuery;
use Illuminate\Contracts\Pagination\LengthAwarePaginator;

class ReportService
{
    public function getLeadsReportByFilters(FilterReportLeadsDTO $filters, int $perPage = 10): LengthAwarePaginator
    {   $paginator = LeadFilterReportQuery::build($filters)
        ->paginate($perPage);
        return $paginator->through(function ($lead) {
            return (new LeadReportResource($lead))->resolve(); 
        });
    }
}