<?php
namespace App\Queries;

use App\Models\User;
use Illuminate\Database\Eloquent\Builder;

class StaftListQuery
{
    public static function build(array $excludedRoles = []): Builder
    {
        $query = User::select('users.id', 'users.name as name', 'users.active')
            ->with([
                'staftDetail' => function ($query) {
                    $query->select('user_id', 'last_name')->with('documents');
                },
                'roles:id,display_name',
            ])->whereDoesntHave('roles', function ($query) use ($excludedRoles) {
                $query->whereIn('name', $excludedRoles);
            });

        return $query->orderBy('name', 'asc');
    }
}