<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Venue extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'ability',
        'active',
    ];

    public function leads(): HasMany
    {
        return $this->hasMany(Lead::class, 'venue_id');
    }
}