<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;

class StatusPipeline extends Model
{
    use HasFactory;
    protected $fillable = [
        'name_status',
        'order_position',
        'color',
        'background_color',
    ];

    protected static function booted()
    {
        static::addGlobalScope('ordered', function ($builder) {
            $builder->orderBy('order_position', 'asc');
        });
    }

    public function leads(): HasMany
    {
        return $this->hasMany(Lead::class, 'status_pipeline_id');
    }
}
