<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\MorphTo;

class Document extends Model
{
    use HasFactory;

    protected $table = 'documents';

    protected $fillable = [
        'documentable_id',
        'documentable_type',
        'file_path',
        'file_name',
        'mime_type',
        'file_size',
        'file_hash',
    ];

    public function documentable(): MorphTo
    {
        return $this->morphTo();
    }
}