<?php

namespace App\Http\Resources\Lead;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class LeadRecentResource extends JsonResource
{
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name_event' => $this->name_event,
            'name_lead_type' => $this->whenLoaded(
                'leadType',
                fn () => $this->leadType->name
            ),
            'estimated_budget' => number_format($this->estimated_budget, 2, ',', '.'),
            'created_at' => $this->created_at->locale('es')->translatedFormat('d F Y')
        ];
    }
}
