<?php

namespace App\Http\Requests\Venue;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class VenueCreateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        return [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('venues', 'name'),
            ],
            'ability' => [
                'required',
                'integer',
                'min:1',
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'El nombre del venue es obligatorio.',
            'name.string' => 'El nombre del venue debe ser una cadena de texto.',
            'name.max' => 'El nombre del venue no puede exceder los :max caracteres.',
            'name.unique' => 'Este nombre de venue ya existe. Por favor, elige uno diferente.',

            'ability.required' => 'La capacidad del venue es obligatoria.',
            'ability.integer' => 'La capacidad debe ser un número entero.',
            'ability.min' => 'La capacidad mínima debe ser al menos :min.',
        ];
    }
}
