<?php

namespace App\Http\Requests\Admin;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class JobUpdateRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
        $jobId = $this->route('id');
        return [
            'name' => [
                'required',
                'string',
                'max:255',
                Rule::unique('jobs', 'name')->ignore($jobId),
            ],
            'active' => [
                'nullable',
                'boolean',
            ],
        ];
    }

    public function messages(): array
    {
        return [
            'name.required' => 'El nombre del cargo es obligatorio.',
            'name.string' => 'El nombre del cargo debe ser una cadena de texto.',
            'name.max' => 'El nombre del cargo no puede exceder los :max caracteres.',
            'name.unique' => 'Este nombre de cargo ya existe. Por favor, elige uno diferente.',
            'active.boolean' => 'El campo "activo" debe ser verdadero o falso.',
        ];
    }

    protected function prepareForValidation(): void
    {
        if ($this->has('active')) {
            $this->merge([
                'active' => filter_var($this->active, FILTER_VALIDATE_BOOLEAN, FILTER_NULL_ON_FAILURE) ?? $this->active,
            ]);
        }
    }
}
