<?php

namespace App\Http\Controllers\Venue;

use App\DTOs\Venue\VenueCreateDto;
use App\Http\Controllers\Controller;
use App\Http\Requests\Venue\VenueCreateRequest;
use App\Http\Requests\Venue\VenueUpdateRequest;
use App\Services\VenueService;
use Illuminate\Http\RedirectResponse;

class VenueController extends Controller
{
    public function __construct(protected VenueService $venueService)
    {
    }

    public function store(VenueCreateRequest $request): RedirectResponse
    {
        $dto = new VenueCreateDto(
            name: $request->input('name'),
            ability: $request->input('ability')
        );

        $venueCreate = $this->venueService->create($dto);

        if (!$venueCreate) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => 'Ocurrió un error al guardar el venue. Intenta nuevamente.']);
        }

        return redirect()->back()->with('success', 'Venue creado correctamente.');
    }

    public function update(VenueUpdateRequest $request, $id): RedirectResponse
    {

        $dto = new VenueCreateDto(
            name: $request->input('name'),
            ability: $request->input('ability')
        );

        $statusPipeline = $this->venueService->update($id, $dto);

        if (!$statusPipeline) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => 'Ocurrió un error al actualizar el venue. Intenta nuevamente.']);
        }
        return redirect()->back()->with('success', 'Venue actualizado correctamente.');
    }

    public function destroy($id): RedirectResponse
    {
        $result = $this->venueService->delete($id);
        if ($result->failed()) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => $result->getMessage()]);
        }
        return redirect()->back()->with('success', $result->getMessage());
    }
}
