<?php

namespace App\Http\Controllers\Superadmin;

use App\DTOs\Department\DepartmentCreateDto;
use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\DepartmentCreateRequest;
use App\Http\Requests\Admin\DepartmentUpdateRequest;
use App\Services\DeparmentService;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;

class DepartmentController extends Controller
{
    public function __construct(protected DeparmentService $deparmentService)
    {
    }

    public function index(): View
    {
        $listData = $this->deparmentService->getPaginated();
        return view('superadmin.departments.index', compact('listData'));
    }

    public function create(): View
    {
        return view('superadmin.departments.create');
    }

    public function edit($id): View
    {
        $department = $this->deparmentService->find($id);
        if (!$department) {
            abort(404);
        }
        return view('superadmin.departments.edit', compact('department'));
    }

    public function store(DepartmentCreateRequest $request): RedirectResponse
    {
        $dto = new DepartmentCreateDto($request->validated());
        $deparment = $this->deparmentService->create($dto);

        if (!$deparment) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => 'Ocurrió un error al guardar el departamento. Intenta nuevamente.']);
        }

        return redirect()->route('superadmin.departments.index')->with('success', 'Departamento creado correctamente.');
    }

    public function update(DepartmentUpdateRequest $request, $id): RedirectResponse
    {
        $dto = new DepartmentCreateDto($request->validated());
        $guest = $this->deparmentService->update($id, $dto);

        if (!$guest) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => 'No se pudo actualizar el departamento.']);
        }

        return redirect()->route('superadmin.departments.index')->with('success', 'Departamento actualizado correctamente.');
    }

    public function destroy($id): RedirectResponse
    {
        $deleted = $this->deparmentService->delete($id);
        if ($deleted) {
            return redirect()->route('superadmin.departments.index')->with('success', 'Departamento eliminado correctamente.');
        }
        return redirect()->route('superadmin.departments.index')->with('error', 'No se pudo eliminar el departamento.');
    }
}
