<?php

namespace App\Http\Controllers\StatusPipeline;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StatusPipelineCreateRequest;
use App\Http\Requests\Admin\StatusPipelineUpdateRequest;
use App\Http\Requests\StatusPipeline\ReorderStatusPipelinesRequest;
use App\Services\StatusPipelineService;
use App\DTOs\StatusPipeline\StatusPipelineCreateDto;
use Illuminate\Http\RedirectResponse;

class StatusPipelineController extends Controller
{
    public function __construct(protected StatusPipelineService $statusPipelineService)
    {
    }

    public function store(StatusPipelineCreateRequest $request): RedirectResponse
    {
        $dto = new StatusPipelineCreateDto(
            name_status: $request->input('name_status'),
            color: $request->input('color'),
            background_color: $request->input('background_color'),
        );

        $statusPipeline = $this->statusPipelineService->create($dto);

        if (!$statusPipeline) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => 'Ocurrió un error al guardar el estado de pipeline. Intenta nuevamente.']);
        }

        return redirect()->back()->with('success', 'Estado creado correctamente.');
    }

    public function update(StatusPipelineUpdateRequest $request, $id): RedirectResponse
    {

        $dto = new StatusPipelineCreateDto(
            name_status: $request->input('name_edit'),
            color: $request->input('color_edit'),
            background_color: $request->input('background_color_edit'),
        );

        $statusPipeline = $this->statusPipelineService->update($id, $dto);

        if (!$statusPipeline) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => 'Ocurrió un error al actualizar el estado de pipeline. Intenta nuevamente.']);
        }
        return redirect()->back()->with('success', 'Estado de pipeline actualizado correctamente.');
    }

    public function destroy($id): RedirectResponse
    {
        $result = $this->statusPipelineService->delete($id);

        if ($result->failed()) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['error' => $result->getMessage()]);
        }

        return redirect()->back()->with('success', $result->getMessage());
    }

    public function reorder(ReorderStatusPipelinesRequest $reorderStatusPipelinesRequest): RedirectResponse
    {
        $items = $reorderStatusPipelinesRequest->items();

        $updated = $this->statusPipelineService->reorder($items);

        if (!$updated) {
            return redirect()->back()->withErrors(['error' => 'No se pudo reordenar los estados']);
        }

        return redirect()->back()->with('success', 'Orden actualizado');
    }
}
