<?php

namespace App\Http\Controllers\Config;

use App\Http\Controllers\Controller;
use App\Services\StatusPipelineService;
use App\Services\VenueService;
use Illuminate\Http\Request;
use Illuminate\View\View;

class ConfigController extends Controller
{
    public function __construct(protected StatusPipelineService $statusPipelineService, protected VenueService $venueService){}

    public function index(): View
    {
        $statusPipelines = $this->statusPipelineService->get();
        $venuesList = $this->venueService->get();
        // dd($statusPipelines);
        return view('config.index', compact('statusPipelines', 'venuesList'));
    }
}