<?php

namespace App\Http\Controllers\Api\StatusPipeline;

use App\Http\Controllers\Controller;
use App\Http\Requests\Admin\StatusPipelineCreateRequest;
use App\Http\Requests\Admin\StatusPipelineUpdateRequest;
use App\Services\StatusPipelineService;
use App\DTOs\StatusPipeline\StatusPipelineCreateDto;
use Illuminate\Http\JsonResponse;

class StatusPipelineController extends Controller
{
    public function __construct(protected StatusPipelineService $statusPipelineService)
    {
    }

    public function index(): JsonResponse
    {
        $listData = $this->statusPipelineService->getPaginated();
        return response()->json($listData);
    }

    public function show($id): JsonResponse
    {
        $statusPipeline = $this->statusPipelineService->find($id);

        if (!$statusPipeline) {
            return response()->json(['message' => 'Estado de pipeline no encontrado.'], 404);
        }

        return response()->json($statusPipeline);
    }

    public function store(StatusPipelineCreateRequest $request): JsonResponse
    {
        $dto = new StatusPipelineCreateDto(
            name_status: $request->input('name_status'),
            order_position: $request->input('order_position'),
            color: $request->input('color'),
            background_color: $request->input('background_color'),
        );

        $statusPipeline = $this->statusPipelineService->create($dto);

        if (!$statusPipeline) {
            return response()->json([
                'message' => 'Error al guardar el estado del pipeline.'
            ], 500);
        }

        return response()->json([
            'message' => 'Estado de pipeline creado correctamente.',
            'data' => $statusPipeline
        ], 201);
    }

    public function update(StatusPipelineUpdateRequest $request, $id): JsonResponse
    {
        $dto = new StatusPipelineCreateDto(
            name_status: $request->input('name_status'),
            order_position: $request->input('order_position'),
            color: $request->input('color'),
            background_color: $request->input('background_color'),
        );

        $statusPipeline = $this->statusPipelineService->update($id, $dto);

        if (!$statusPipeline) {
            return response()->json([
                'message' => 'No se pudo actualizar el estado del pipeline.',
            ], 404);
        }

        return response()->json([
            'message' => 'Estado de pipeline actualizado correctamente.',
            'data' => $statusPipeline
        ], 200); // 200 OK
    }

    public function destroy($id): JsonResponse
    {
        $deleted = $this->statusPipelineService->delete($id);

        if (!$deleted) {
            return response()->json(['message' => 'No se pudo eliminar el estado del pipeline o no existe.'], 404);
        }

        return response()->json(null, 204);
    }
}
