<?php

namespace App\Http\Controllers\Api\Lead;

use App\DTOs\Lead\LeadApiCreateDTO;
use App\Http\Controllers\Controller;
use App\Http\Requests\Lead\CreateLeadApiRequest;
use App\Services\LeadService;
use Illuminate\Http\JsonResponse;

class LeadApiController extends Controller
{
    public function __construct(
        protected LeadService $leadService,
    ) {
    }

    public function store(CreateLeadApiRequest $request): JsonResponse
    {
        $dto = new LeadApiCreateDTO($request->validated());
        
        $lead = $this->leadService->createWithApi($dto);

        if (!$lead) {
            return response()->json([
                'success' => false,
                'message' => 'Error al crear el lead'
            ], 500);
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Se guardo correctamente la información, nosotros nos comunicamos contigo.',
            'data' => $lead
        ], 201);
    }
}
