<?php
namespace App\DTOs\Staft;

class StaftCreateDto
{
    public ?string $last_name;
    public ?string $phone;
    public ?string $department_id;
    public ?string $user_id;
    

    public function __construct(array $data)
    { 
        $this->last_name = $data['last_name'];
        $this->user_id = $data['user_id'] ?? null;
        $this->phone = $data['phone'] ?? null;
        $this->department_id = $data['department_id'] ?? null;
    }

    public static function fromRequest(\Illuminate\Http\Request $request): self
    {
        return new self($request->only(['last_name', 'user_id', 'phone', 'department_id']));
    }

    public function toArray(): array
    {
        return [
            'last_name' => $this->last_name,
            'phone' => $this->phone,
            'department_id' => $this->department_id,
            'user_id' => $this->user_id,
        ];
    }
}