<?php

namespace App\DTOs\Lead;

use App\Http\Requests\Lead\CreateLeadApiRequest;

class LeadApiCreateDTO
{
    public int $lead_type_id;
    public string $name_event;
    public int $venue_id;
    public int $number_of_people;
    public int $rooms_guests;
    public float $estimated_budget;
    public string $name;
    public string $last_name;
    public string $email;
    public ?string $phone;
    public ?string $country;

    public ?string $additional_information;
    public ?int $status_pipeline_id = null;
    public ?string $money_budget;

    public ?string $checkin_at;
    public ?string $checkout_at;
    public bool $is_flexible;
    public ?string $flexible_month;
    public ?int $flexible_duration;

    public function __construct(array $data)
    {
        $this->lead_type_id = $data['lead_type_id'];

        $this->name_event = $data['name_event'];
        $this->venue_id = $data['venue_id'];
        $this->number_of_people = $data['number_of_people'];
        $this->rooms_guests = $data['rooms_guests'];
        $this->estimated_budget = $data['estimated_budget'];
        $this->name = $data['name'];
        $this->last_name = $data['last_name'];
        $this->email = $data['email'];
        $this->phone = $data['phone'] ?? null;
        $this->country = $data['country'] ?? null;
        $this->additional_information = $data['additional_information'] ?? null;

        $this->is_flexible = (bool) ($data['is_flexible'] ?? false);
        $this->checkin_at = $data['checkin_at'] ?? null;
        $this->checkout_at = $data['checkout_at'] ?? null;
        $this->flexible_month = $data['flexible_month'] ?? null;
        $this->flexible_duration = $data['flexible_duration'] ?? null;
    }

    public static function fromRequest(CreateLeadApiRequest $request): self
    {
        return new self($request->validated());
    }

    public function toArray(): array
    {
        return [
            'lead_type_id' => $this->lead_type_id,
            'name_event' => $this->name_event,
            'venue_id' => $this->venue_id,
            'number_of_people' => $this->number_of_people,
            'rooms_guests' => $this->rooms_guests,
            'estimated_budget' => $this->estimated_budget,
            'name' => $this->name,
            'last_name' => $this->last_name,
            'email' => $this->email,
            'phone' => $this->phone,
            'additional_information' => $this->additional_information,
            'status_pipeline_id' => $this->status_pipeline_id,
            'money_budget' => 'USD',
            'country' => $this->country,
            'is_flexible' => $this->is_flexible,
            'checkin_at' => $this->checkin_at,
            'checkout_at' => $this->checkout_at,
            'flexible_month' => $this->flexible_month,
            'flexible_duration' => $this->flexible_duration,
        ];
    }
}