<?php

namespace App\DTOs\Department;

use Illuminate\Http\Request;

class DepartmentCreateDto
{
    public string $name;
    public bool $active;

    public function __construct(array $data)
    {
        $this->name = $data['name'];
        $this->active = $data['active'] ?? true;
    }
    
    public static function fromRequest(Request $request): self
    {
        return new self($request->only(['name', 'active']));
    }

    public function toArray(): array
    {
        return [
            'name' => $this->name,
            'active' => $this->active,
        ];
    }
}