<?php
namespace App\DTOs\Auth;

class LoginDTO
{
    public string $email;
    public string $password;
    public bool $remember;

    public function __construct(array $data)
    {
        $this->email = $data['email'];
        $this->password = $data['password'];
        $this->remember = $data['remember'] ?? false;
    }

    public static function fromRequest(\Illuminate\Http\Request $request): self
    {
        return new self($request->only(['email', 'password', 'remember']));
    }
}