@php
    $columns = [
        [
            'label' => 'Invitado',
            'width' => '300px',
            'render' => fn($rsvp) => e($rsvp->guest->name ?? '—'),
        ],
        [
            'label' => 'Correo',
            'width' => '300px',
            'render' => fn($rsvp) => e($rsvp->guest->email ?? '—'),
        ],
        [
            'label' => 'Teléfono',
            'width' => '200px',
            'render' => fn($rsvp) => e($rsvp->guest->phone ?? '—'),
        ],
        [
            'label' => 'Número Asistentes',
            'width' => '160px',
            'render' => fn($rsvp) =>e($rsvp->confirmed_guests ?? '—'),
        ],
        [
            'label' => 'Asistencia',
            'width' => '160px',
            'render' => fn($rsvp) => $rsvp->attendance === 'yes' ? 'Asistirá' : 'No asistirá',
        ],
        [
            'label' => 'Restricciones alimenticias',
            'width' => '300px',
            'render' => fn($rsvp) => e($rsvp->dietary_restrictions ?: '—'),
        ],
        [
            'label' => 'Comentarios',
            'width' => '300px',
            'render' => fn($rsvp) => e($rsvp->comments ?: '—'),
        ],
        [
            'label' => 'Confirmado el',
            'width' => '200px',
            'render' => fn($rsvp) => optional($rsvp->confirmed_at)->format('d/m/Y H:i') ?: '—',
        ],
    ];
    $rsvpTabs = [
        'confirmed' => 'Confirmados',
        'not_confirmed' => 'No confirmados',
    ];
@endphp

<x-layouts.auth-layout>
    <div class="flex flex-col max-w-[960px]">
        <div class="flex flex-wrap justify-between gap-3 py-4">
            <h2 class="text-complement300 font-roboto text-size-subtitle font-medium">Mis Confirmaciones</h2>
        </div>
        <div class="mb-8">
            <x-tabs.tab-links :tabs="$rsvpTabs" />
        </div>
        <div class="py-3">
            @if ($status === 'confirmed')
                <x-tables.table-with-pagination :columns="$columns" :items="$rsvps" />
            @elseif ($status === 'not_confirmed')
                <x-alerts.success />
                <x-alerts.error />
                <div class="overflow-hidden">
                    @forelse ($rsvps as $guest)
                        <x-cards.contact-card :slug="$guest->slug" :name="$guest->name" :phone="$guest->phone ?? '(sin teléfono)'"
                            :email="$guest->email ?? '(sin email)'" buttonText="Enviar Recordatorio"
                            onClick="alert('Recordatorio enviado a {{ addslashes($guest->name) }}')" />
                    @empty
                        <p class="p-4 text-center text-gray-500">No hay invitados sin confirmar.</p>
                    @endforelse

                    @if ($rsvps->hasPages())
                        <div class="px-4 py-3">
                            {{ $rsvps->withQueryString()->links() }}
                        </div>
                    @endif
                </div>
            @endif
        </div>
    </div>
</x-layouts.auth-layout>