<x-layouts.auth-layout>
    @if(auth()->user()->hasAnyRole(['admin']))
        <div class="flex flex-wrap gap-4 p-4">
            <div class="flex min-w-[158px] flex-1 flex-col gap-2 rounded-xl p-6 bg-[#f0f0f4]">
                <p class="text-[#111117] text-base font-medium leading-normal">Total Invitations</p>
                <p class="text-[#111117] tracking-light text-2xl font-bold leading-tight">1,234</p>
            </div>
            <div class="flex min-w-[158px] flex-1 flex-col gap-2 rounded-xl p-6 bg-[#f0f0f4]">
                <p class="text-[#111117] text-base font-medium leading-normal">Active Users</p>
                <p class="text-[#111117] tracking-light text-2xl font-bold leading-tight">567</p>
            </div>
            <div class="flex min-w-[158px] flex-1 flex-col gap-2 rounded-xl p-6 bg-[#f0f0f4]">
                <p class="text-[#111117] text-base font-medium leading-normal">Templates</p>
                <p class="text-[#111117] tracking-light text-2xl font-bold leading-tight">89</p>
            </div>
        </div>
    @endif
    @if(auth()->user()->hasAnyRole(['organizer']))
        <div class="grid grid-cols-1 md:grid-cols-2 gap-4 max-w-xl">
            <div class="bg-white border border-gray-200 p-6 md:p-8 rounded-2xl">
                <div class="bg-gray-100 text-gray-800 w-12 h-12 flex justify-center items-center rounded-md mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M18 18.72a9.094 9.094 0 0 0 3.741-.479 3 3 0 0 0-4.682-2.72m.94 3.198.001.031c0 .225-.012.447-.037.666A11.944 11.944 0 0 1 12 21c-2.17 0-4.207-.576-5.963-1.584A6.062 6.062 0 0 1 6 18.719m12 0a5.971 5.971 0 0 0-.941-3.197m0 0A5.995 5.995 0 0 0 12 12.75a5.995 5.995 0 0 0-5.058 2.772m0 0a3 3 0 0 0-4.681 2.72 8.986 8.986 0 0 0 3.74.477m.94-3.197a5.971 5.971 0 0 0-.94 3.197M15 6.75a3 3 0 1 1-6 0 3 3 0 0 1 6 0Zm6 3a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0Zm-13.5 0a2.25 2.25 0 1 1-4.5 0 2.25 2.25 0 0 1 4.5 0Z" />
                    </svg>
                </div>
                <h3 class="font-roboto text-size-heading font-light">Confirmaciones de asistencia</h3>
                <p class="!text-size-hero text-black font-medium">{{ $numberConfirm }}</p>
            </div>
            <div class="bg-white border border-gray-200 p-6 md:p-8 rounded-2xl">
                <div class="bg-gray-100 text-gray-800 w-12 h-12 flex justify-center items-center rounded-md mb-4">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5"
                        stroke="currentColor" class="size-6">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M18 7.5v3m0 0v3m0-3h3m-3 0h-3m-2.25-4.125a3.375 3.375 0 1 1-6.75 0 3.375 3.375 0 0 1 6.75 0ZM3 19.235v-.11a6.375 6.375 0 0 1 12.75 0v.109A12.318 12.318 0 0 1 9.374 21c-2.331 0-4.512-.645-6.374-1.766Z" />
                    </svg>
                </div>
                <h3 class="font-roboto text-size-heading font-light">Total de personas confirmadas</h3>
                <p class="!text-size-hero text-black font-medium">{{ $numberConfirm }}</p>
            </div>
        </div>
    @endif
</x-layouts.auth-layout>