<?php

namespace App\Http\Requests\Organizer;

use Illuminate\Foundation\Http\FormRequest;

class UpdateEventRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'name' => ['required', 'string', 'max:255'],
            'name_husband' => ['required', 'string', 'max:255'],
            'name_wife' => ['required', 'string', 'max:255'],
            'description' => ['nullable', 'string'],
            'whatsapp_contact' => ['nullable', 'string', 'max:20'],

            'parents' => ['nullable', 'string', 'max:500'],

            'ceremony_place' => ['required', 'string', 'max:255'],
            'location_ceremony' => ['required', 'string'],
            'location_google_maps_ceremony' => ['required', 'url', 'max:2048'],
            'start_date_only' => ['required', 'date_format:Y-m-d'],
            'start_time_only' => ['required', 'date_format:H:i'],

            'civil_place' => ['nullable', 'string', 'max:255'],
            'location_civil' => ['nullable', 'string'],
            'location_google_maps_civil' => ['nullable', 'url', 'max:2048'],
            'start_date_only_civil' => ['nullable', 'date_format:Y-m-d'],
            'start_time_only_civil' => ['nullable', 'date_format:H:i'],
        ];
    }

    /**
     * Get the error messages for the defined validation rules.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'name.required' => 'El nombre del evento es obligatorio.',
            'name.max' => 'El nombre del evento no debe exceder los 255 caracteres.',

            'name_husband.required' => 'El nombre del esposo es obligatorio.',
            'name_wife.required' => 'El nombre de la esposa es obligatorio.',

            'whatsapp_contact.max' => 'El contacto de WhatsApp no debe exceder los 20 caracteres.',

            // --- Mensajes Boda Ceremonial ---
            'ceremony_place.required' => 'El lugar de la boda ceremonial es obligatorio.',
            'location_ceremony.required' => 'La ubicación la boda ceremonial es obligatorio.',

            'location_google_maps_ceremony.required' => 'La URL de Google Maps para la ceremonia es obligatoria.',
            'location_google_maps_ceremony.url' => 'La ubicación de Google Maps ceremonial debe ser una URL válida.',

            'start_date_only.required' => 'La fecha de la ceremonia es obligatoria.',
            'start_date_only.date_format' => 'El formato de la fecha de la ceremonia no es válido (YYYY-MM-DD).',

            'start_time_only.required' => 'La hora de la ceremonia es obligatoria.',
            'start_time_only.date_format' => 'El formato de la hora de la ceremonia no es válido (HH:MM).',

            // --- Mensajes Boda Civil ---
            'civil_place.max' => 'El lugar de la boda civil no debe exceder los 255 caracteres.',
            'location_google_maps_civil.url' => 'La ubicación de Google Maps civil debe ser una URL válida.',
            'start_date_only_civil.date_format' => 'El formato de la fecha de la boda civil no es válido (YYYY-MM-DD).',
            'start_time_only_civil.date_format' => 'El formato de la hora de la boda civil no es válido (HH:MM).',
        ];
    }
}