<?php

namespace App\Http\Controllers\Organizer;

use App\DTOs\Guest\CreateGuestDTO;
use App\DTOs\Guest\UpdateGuestDTO;
use App\Http\Controllers\Controller;
use App\Http\Requests\Organizer\UpdateGuestRequest;
use App\Services\GuestService;
use Illuminate\Http\Request;


class GuestController extends Controller
{
    protected $guestService;

    public function __construct(GuestService $guestService)
    {
        $this->guestService = $guestService;
    }

    public function index()
    {
        $guests = $this->guestService->getPaginated(15);
        return view('organizer.guests.index', compact('guests'));
    }

    public function create()
    {
        return view('organizer.guests.create');
    }

    public function show($id)
    {
        $guest = $this->guestService->find($id);
        return view('organizer.guests.show', compact('guest'));
    }

    public function edit($id)
    {
        $guest = $this->guestService->find($id);
        if (!$guest) {
            abort(404);
        }
        return view('organizer.guests.edit', compact('guest'));
    }

    public function store(UpdateGuestRequest $request)
    {
        $dto = new CreateGuestDTO($request->validated());
        $guest = $this->guestService->create($dto);

        if (!$guest) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['general' => 'Ocurrió un error al guardar el invitado. Intenta nuevamente.']);
        }

        return redirect()->route('organizer.guests.index')->with('success', 'Invitado creado correctamente.');
    }

    public function update(UpdateGuestRequest $request, $id)
    {
        $dto = new UpdateGuestDTO($request->validated());
        $guest = $this->guestService->update($id, $dto);

        if (!$guest) {
            return redirect()->back()
                ->withInput()
                ->withErrors(['general' => 'No se pudo actualizar el invitado.']);
        }

        return redirect()->route('organizer.guests.index')->with('success', 'Invitado actualizado correctamente.');
    }

    public function destroy($id)
    {
        $deleted = $this->guestService->delete($id);
        if ($deleted) {
            return redirect()->route('organizer.guests.index')->with('success', 'Invitado eliminado correctamente.');
        }
        return redirect()->route('organizer.guests.index')->with('error', 'No se pudo eliminar el invitado.');
    }
}