<?php

namespace App\Http\Controllers\Guest;

use App\DTOs\Guest\RsvpDto;
use App\Http\Controllers\Controller;
use App\Http\Requests\StoreRsvpRequest;
use App\Services\GuestService;
use App\Services\RsvpService;
use Illuminate\Http\JsonResponse;

class RsvpController extends Controller
{
    public function __construct(protected RsvpService $rsvpService, protected GuestService $guestService)
    {
    }

    public function store(StoreRsvpRequest $request): JsonResponse
    {
        $dto = new RsvpDto($request->validated());

        $guestFind = $this->guestService->findBySlug($dto->slug);
        if ($guestFind == null) {
            return response()->json([
                'success' => false,
                'message' => 'Lo sentimos, no te encuentras en la lista de invitados.'
            ], 400);
        }

        $existsConfirmation = $this->rsvpService->existsConfirmationByGuest($guestFind->id);
        if ($existsConfirmation) {
            return response()->json([
                'success' => false,
                'message' => 'Ya has confirmado tu asistencia.'
            ], 400);
        }

        $rsvp = $this->rsvpService->confirm($dto, $guestFind->id);

        if (!$rsvp) {
            return response()->json([
                'success' => false,
                'message' => 'Ocurrió un error al guardar tu confirmación. Intenta nuevamente.'
            ], 500);
        }
        
        return response()->json([
            'success' => true,
            'message' => '¡Gracias por confirmar tu asistencia!'
        ]);
    }
}