<x-layouts.app-layout>
    <div class="flex flex-col items-center p-4 md:p-6">
        <div class="w-full max-w-4xl bg-white shadow-xl rounded-lg p-8">
            <div class="max-w-lg mb-6">
                <h1 class="text-size-main text-emerald-600 font-medium mb-2">Bienvenido..</h1>
                <h2 class="text-primary text-size-subtitle mb-4">Por favor sigue los 3 Pasos</h2>
                <p class="text-size-heading font-bold text-primary" id="step-description">El sistema permite generar varios códigos de barras al mismo tiempo, pudiendo crear hasta 50 códigos por cada lote.</p>
            </div>

            <div id="error-container"
                class="hidden max-w-xl bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded relative mb-4"
                role="alert">
                <strong class="font-bold">¡Error!</strong>
                <span id="error-message" class="block sm:inline ml-2"></span>
            </div>

            <div id="loading-indicator" class="hidden text-center p-4 bg-emerald-50 rounded-lg mb-6">
                <p class="text-emerald-600 text-size-heading font-semibold flex items-center justify-center">
                    <svg class="animate-spin -ml-1 mr-3 h-5 w-5 text-emerald-600" xmlns="http://www.w3.org/2000/svg"
                        fill="none" viewBox="0 0 24 24">
                        <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4">
                        </circle>
                        <path class="opacity-75" fill="currentColor"
                            d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z">
                        </path>
                    </svg>
                    Generando códigos... Por favor, espere.
                </p>
                <p class="text-size-small-heading mt-1" id="loading-progress"></p>
            </div>

            <div id="step-1" class="step-content">
                <h2 class="text-size-subtitle font-semibold text-emerald-800">Paso 1.</h2>
                <p class="text-primary font-bold text-size-heading mb-4">Ingresa el número de códigos de barras que quieres generar.</p>
                <form id="quantity-form" class="flex gap-4 items-center">
                    <input type="number" id="quantity-input" placeholder="Ej: 10" min="1" value="1"
                        class="text-parrafo p-3 border border-gray-300 rounded-lg shadow-sm focus:ring-emerald-500 focus:border-emerald-500 w-32 text-center"
                        required>
                    <button type="submit" id="start-generate-btn"
                        class="bg-emerald-500 hover:bg-emerald-700 text-white text-parrafo font-bold py-3 px-6 rounded-lg transition duration-150 shadow-md">
                        Iniciar Generación
                    </button>
                </form>
            </div>

            <div id="step-2" class="step-content hidden">
                <h2 class="text-size-subtitle font-semibold text-emerald-800 mb-4">Paso 2: Códigos Generados (<span
                        id="count-display-2">0</span>)</h2>
                <p class="text-primary text-size-heading font-bold">Procede al siguiente paso por favor. La siguiente imagen solo es representativa de los códigos de barras generados.</p>
                <div id="barcode-list-container"
                    class="border border-dashed border-gray-400 p-4 mt-4 bg-gray-50 rounded-lg">
                    <div id="barcode-list" class="flex flex-wrap justify-start">
                        </div>
                </div>
            </div>

            <div id="step-3" class="step-content hidden mt-8">
                <h2 class="text-size-subtitle font-semibold text-emerald-800">Paso 3:</h2>
                <p class="text-primary font-bold text-size-heading mb-4">Presiona el primer botón para guardar el documento en tu computadora o celular y después imprimirlo.</p>
                <div class="controls flex flex-col md:flex-row gap-4">
                    
                    <button type="button" id="download-word-btn"
                        class="shrink-0 bg-emerald-500 hover:bg-emerald-700 text-white text-parrafo font-bold py-3 px-6 rounded-lg transition duration-150 shadow-md">
                        Descargar (Para Imprimir)
                    </button>

                    <button type="button" id="clear-btn"
                        class="shrink-0 bg-red-500 hover:bg-red-600 text-white text-parrafo font-bold py-3 px-6 rounded-lg transition duration-150 shadow-md">
                        Volver a Empezar
                    </button>
                </div>
            </div>

        </div>
    </div>
</x-layouts.app-layout>