<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Generador de Etiquetas</title>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link
        href="https://fonts.googleapis.com/css2?family=Inter:ital,opsz,wght@0,14..32,100..900;1,14..32,100..900&display=swap"
        rel="stylesheet">
    <!-- @vite(['resources/css/app.css', 'resources/js/app.js']) -->
    @php
        $manifest = json_decode(file_get_contents(public_path('build/manifest.json')), true);
    @endphp
    <link rel="stylesheet" href="{{ asset('build/' . $manifest['resources/css/app.css']['file']) }}">
    <style>
        @media print {

            /* Ocultar todos los elementos de control y navegación */
            .print-hidden,
            .step-1,
            .step-3 .controls {
                display: none !important;
            }

            /* Mostrar solo la lista de códigos y hacer que ocupen la página */
            .print-area {
                width: 100%;
                margin: 0;
                padding: 0;
            }

            /* Resetear estilos para impresión de etiquetas */
            .barcode-item {
                border: none !important;
                margin: 0;
                padding: 5px;
                /* Ajuste para que quepan 3 o 4 por fila */
                width: 33.333% !important;
                flex-grow: 0;
            }

            body {
                margin: 0;
                padding: 0;
                background-color: white;
            }
        }
    </style>
</head>

<body class="bg-gray-100 antialiased">
    {{ $slot }}
    <script type="module" src="{{ asset('build/' . $manifest['resources/js/app.js']['file']) }}"></script>
</body>

</html>