<?php 
    require_once ABSPATH . 'vendor/autoload.php';
    use PhpOffice\PhpWord\IOFactory;
    use Dompdf\Dompdf;
    use Dompdf\Options;
    # Oculta Adminbar    
        show_admin_bar(false);
    # Add Thumbnails Support
        add_theme_support( 'post-thumbnails'); 
    # Remueve WP Version   
        function wpbeginner_remove_version() {
            return '';
        } 
        add_filter('the_generator', 'wpbeginner_remove_version');
    
   
        # Remueve Welcome Widget from the Dashboard
        function remove_dashboard_widgets() {
            remove_meta_box( 'dashboard_quick_press', 'dashboard', 'side' );
            remove_meta_box( 'dashboard_incoming_links', 'dashboard', 'normal' );
            remove_meta_box( 'dashboard_right_now', 'dashboard', 'normal' );
            remove_meta_box( 'dashboard_activity', 'dashboard', 'normal' );
            remove_meta_box( 'dashboard_plugins', 'dashboard', 'normal' );
            remove_meta_box( 'dashboard_recent_drafts', 'dashboard', 'normal' );
            remove_meta_box( 'dashboard_recent_comments', 'dashboard', 'normal' );
            remove_meta_box( 'dashboard_primary', 'dashboard', 'side' );
            remove_meta_box( 'dashboard_secondary', 'dashboard', 'side' );
        }
        add_action('wp_dashboard_setup', 'remove_dashboard_widgets' );
        remove_action( 'welcome_panel', 'wp_welcome_panel' );

    # Agrega Canalla Plugin Styles
        define( 'MY_CANALLA_PATH', get_stylesheet_directory() . '/assets/inc/plugins/canalla/' );
        define( 'MY_CANALLA_URL', get_stylesheet_directory_uri() . '/assets/inc/plugins/canalla/' );
        include_once( MY_CANALLA_PATH . 'admin-ui.php' );
        // Customize the url setting to fix incorrect asset URLs.
        add_filter('canalla/settings/url', 'my_canalla_settings_url');
        function my_canalla_settings_url() {
            return MY_CANALLA_URL;
        }

    # Guarda y sincroniza ACF FILES
        function my_acf_json_save_point( $path ) {
            $path = get_stylesheet_directory() . '/assets/inc/acfCustom/';
            return $path;
        }
        add_filter('acf/settings/save_json', 'my_acf_json_save_point');
        function my_acf_json_load_point( $paths ) {
            unset($paths[0]);
            $paths[] = get_stylesheet_directory() . '/assets/inc/acfCustom/';
            return $paths;  
        }
        add_filter('acf/settings/load_json', 'my_acf_json_load_point');
    # Oculta elementos del menú START
        function remove_menu_elements() {
            $userData = wp_get_current_user();
            if($userData->data->user_login != 'AdminTI'){
                //remove_menu_page( 'index.php' );                  //Dashboard
                remove_menu_page( 'edit.php' );                   //Posts
                remove_menu_page( 'upload.php' );                 //Media
                //remove_menu_page( 'edit.php?post_type=page' );    //Pages
                remove_menu_page( 'edit-comments.php' );          //Comments
                remove_menu_page( 'themes.php' );                 //Appearance
                remove_menu_page( 'plugins.php' );                //Plugins
                remove_menu_page( 'users.php' );                  //Users
                remove_menu_page( 'tools.php' );                  //Tools
                remove_menu_page( 'tools.php' );                  //Tools
                // remove_menu_page( 'profile.php' );                  //Profile
                //   remove_menu_page( 'options-general.php' );        //Settings
        
            }
        }
        add_action( 'admin_menu', 'remove_menu_elements' );
        $userData = wp_get_current_user();
        if(isset($userData->data->user_login)){
            if($userData->data->user_login != 'AdminTI'){
                //Oculta custom fields
                add_filter('acf/settings/show_admin', '__return_false');
            }
        }

    # Desabilita gutenberg
        add_filter('use_block_editor_for_post_type', '__return_false', 100);
    # Remueve elementos de post
        function remove_elements_support() {
            // remove_post_type_support( 'post', 'editor' );
            remove_post_type_support( 'page', 'editor' );
            remove_post_type_support( 'usuario', 'editor' );
            remove_post_type_support( 'email', 'editor' );
            // remove_post_type_support( 'place', 'editor' ); //En un custom postype

            // ‘title’
            // ‘editor’ (content)
            // ‘author’
            // ‘thumbnail’ (featured image) (current theme must also support Post Thumbnails)
            // ‘excerpt’
            // ‘trackbacks’
            // ‘custom-fields’
            // ‘comments’ (also will see comment count balloon on edit screen)
            // ‘revisions’ (will store revisions)
            // ‘page-attributes’ (template and menu order) (hierarchical must be true)
            // ‘post-formats’ removes post formats, see Post Formats
        }
        add_action('init', 'remove_elements_support', 100);

    # Ejemplo de Pagina de opciones     
        // require('assets/inc/acf/option-page/settings.php');
    # Ejemplo de CPT
        include 'assets/inc/cpt/emails.php';
        include 'assets/inc/cpt/formatos.php';
        include 'assets/inc/cpt/coberturas.php';
        include 'assets/inc/cpt/servicios.php';
        include 'assets/inc/cpt/procesos.php';
        include 'assets/inc/cpt/documentos.php';
    # Permite retornar mas entradas en un query
        add_filter('graphql_connection_max_query_amount', function($amount, $source, $args, $context, $info) {
            $amount = 1000; // whatever you want the limit to be, in this case 1000.
            return $amount;
        }, 10, 5 );    
    # SAVE EMAIL IN CPT
        function save_email_cpt($parameters){
            try {
                date_default_timezone_set("America/Mexico_City");
                $fecha = date("Y-m-d H:i:s");
                //code insert
                global $user_ID;
                $new_post = array(
                    'post_title' => "Email de ".$parameters["name"]." - ".$fecha,
                    'post_status' => 'publish',
                    'post_date' => $fecha,
                    'post_author' => $user_ID,
                    'post_type' => 'email'
                );
                $post_id = wp_insert_post($new_post);
                if($post_id){
                    update_field('asunto', $parameters["subject"], $post_id);
                    update_field('inmobiliaria', $parameters["inmobiliaria"], $post_id);
                    update_field('numero_poliza', $parameters["numeroPoliza"], $post_id);
                    update_field('nombre', $parameters["name"], $post_id);
                    update_field('apellido', $parameters["lastname"], $post_id);
                    update_field('correo', $parameters["email"], $post_id);
                    update_field('telefono', $parameters["phone"], $post_id);
                }
                return true;
            } catch (\Throwable $th) {
                return false;
            }
        }
    # SMTP Authentication
            // function send_smtp_email( $phpmailer ) {
            //     $phpmailer->isSMTP();
            //     $phpmailer->Host = '';
            //     $phpmailer->Port = 465; // could be different
            //     $phpmailer->Username = ''; // if required
            //     $phpmailer->Password = ''; // if required
            //     $phpmailer->SMTPAuth = true; // if required
            //     $phpmailer->SMTPSecure = 'ssl'; // enable if required, 'tls' is another possible value
            //     $phpmailer->From = '';
            //     $phpmailer->FromName = '';
            // }
            // add_action( 'phpmailer_init', 'send_smtp_email' );
    # SEND MAIL
            function sendMail($parameters){
                $formularioData = get_field("formulario", 253);
                $correos = [];
                foreach ($formularioData["correos"] as $key => $value) {
                    array_push($correos, $value["correo"]);
                }
                try {
                    $payload = json_encode($parameters);
                    $url = get_template_directory_uri().'/mailtpl.php';
                    $ch = curl_init();
                    curl_setopt ($ch, CURLOPT_URL, $url);
                    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
                    curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
                    curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
                    curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 5);
                    curl_setopt ($ch, CURLOPT_RETURNTRANSFER, true);
                    $contents = curl_exec($ch);
                    if (curl_errno($ch)) {
                        echo curl_error($ch);
                        echo "\n<br />";
                        $contents = '';
                    } else {
                        curl_close($ch);
                    }
            
                    if (!is_string($contents) || !strlen($contents)) {
                        // echo "Failed to get contents.";
                        $contents = '';
                    }
                    $to = $correos;
                    $subject = 'House Protect | Contacto';
                    $body = $contents;
                    $headers = array('Content-Type: text/html; charset=UTF-8');
                    $result = wp_mail($to, $subject, $body, $headers);
                    return $result;
                } catch (\Throwable $th) {
                    return false;
                }
            }
    # API MAIL
        function pluginname_get_post_items($request) {
            $parameters = $request->get_params();
            
            if(save_email_cpt($parameters)){
                if(sendMail($parameters)){
                    $resultado = array('code' => "success", 'message' => "El mensaje ha sido envidado exitosamente.");
                    return $resultado;
                }else{
                    $resultado = array('code' => "error", 'message' => "Algo salió mal, intenta de nuevo.");
                    return $resultado;
                }
            }else{
                $resultado = array('code' => "error", 'message' => "Algo salió mal, intenta de nuevo.");
                return $resultado;
            }  
        }
        
        function pluginname_register_api_endpoints() {
        register_rest_route( 'wp/v2', '/mail', array(
            'methods' => 'POST',
            'callback' => 'pluginname_get_post_items',
        ) );
        }
        
        add_action( 'rest_api_init', 'pluginname_register_api_endpoints' );






        function custom_generate_token_slug($data, $postarr) {
            // Verifica que sea tu Custom Post Type
            if ($data['post_type'] === 'proceso' && empty($postarr['ID'])) {
                // Genera un token aleatorio (ejemplo: 8 caracteres alfanuméricos)
                $token = substr(md5(uniqid(mt_rand(), true)), 0, 64);
        
                // Asegura que el slug sea único
                while (get_page_by_path($token, OBJECT, 'proceso')) {
                    $token = substr(md5(uniqid(mt_rand(), true)), 0, 64);
                }
        
                // Asigna el token como slug
                $data['post_name'] = $token;
            }
        
            return $data;
        }
        add_filter('wp_insert_post_data', 'custom_generate_token_slug', 10, 2);


        // function disable_rest_api_for_cpt($response, $object, $request) {
        //     if ($object->post_type === 'proceso') {
        //         return new WP_Error('rest_forbidden', __('No tienes permiso para acceder a este recurso.'), ['status' => 403]);
        //     }
        //     return $response;
        // }
        // add_filter('rest_prepare_tu_custom_post_type', 'disable_rest_api_for_cpt', 10, 3);

        // function disable_cpt_single_template($template) {
        //     if (is_singular('proceso')) {
        //         wp_redirect(home_url()); // Redirige al inicio
        //         exit;
        //     }
        //     return $template;
        // }
        // add_filter('template_include', 'disable_cpt_single_template');
        
        // function exclude_cpt_from_queries($query) {
        //     if (!is_admin() && $query->is_main_query() && !$query->is_single()) {
        //         $query->set('post_type', array_diff((array) $query->get('post_type'), ['proceso']));
        //     }
        // }
        // add_action('pre_get_posts', 'exclude_cpt_from_queries');
        
    
        
function sendMailCreateProceso($email, $urlPage, $titulo){
    $data = [
        "url" => $urlPage,
        "urlimages" => get_template_directory_uri()
    ];
    $correos = [];
    array_push($correos, $email);
    try {
        $payload = json_encode($data);
        $url = get_template_directory_uri().'/mailtplCreateProceso.php';
        $ch = curl_init();
        curl_setopt ($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
        curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, true);
        $contents = curl_exec($ch);
        if (curl_errno($ch)) {
            echo curl_error($ch);
            echo "\n<br />";
            $contents = '';
        } else {
            curl_close($ch);
        }

        if (!is_string($contents) || !strlen($contents)) {
            // echo "Failed to get contents.";
            $contents = '';
        }
        $to = $correos;
        $subject = 'House Protect | '.$titulo;
        $body = $contents;
        $headers = array('Content-Type: text/html; charset=UTF-8');
        $result = wp_mail($to, $subject, $body, $headers);
        return $result;
        return true;
    } catch (\Throwable $th) {
        return $th;
    }
}
    
// Endpoint para crear un nuevo proceso
function crear_proceso_endpoint(WP_REST_Request $request) {
    $parameters = $request->get_params();
    $titulo = $request->get_param('title');
    $nombreRecibo = $request->get_param('nombreRecibo');
    $email = $request->get_param('email');
    $pin = $request->get_param('pin');
    $monto = $request->get_param('monto');
    $poliza = $request->get_param('poliza');
    // $inmueble = $request->get_param('inmueble_garantia');
    $figura = $request->get_param('figura');
    $baseURL = $request->get_param('baseURL');


    if ($email && $pin) {
        if(validate_temp_pin($email, $pin)){

        }else{
            return new WP_REST_Response(array(
                'message' => 'Pin invalido',
            ), 200);
        }        
    }else{
        return new WP_Error('error', 'Falta pin o email', array('status' => 400));
    }

    // if ($monto) {
    //     $monto = preg_replace('/[^0-9.]/', '', $monto); // Elimina todo excepto números y punto
    //     $monto = floatval($monto); // Convierte a número decimal
    // }

    if (!$titulo) {
        return new WP_Error('no_title', 'El título es obligatorio', array('status' => 400));
    }

    $nuevo_proceso = array(
        'post_title'   => $titulo,
        'post_status'  => 'publish',
        'post_type'    => 'proceso'
    );

    $post_id = wp_insert_post($nuevo_proceso);

    if (is_wp_error($post_id)) {
        return new WP_Error('insert_error', 'Error al crear el proceso', array('status' => 500));
    }

    if ($nombreRecibo) {
        update_post_meta($post_id, 'nombreRecibo', sanitize_text_field($nombreRecibo));
    }
    if ($email) {
        update_post_meta($post_id, 'email', sanitize_email($email));
    }
    if ($monto) {
        update_post_meta($post_id, 'monto', $monto);
    }
    if ($poliza) {
        update_post_meta($post_id, 'poliza', sanitize_text_field($poliza));
    }
    // if ($inmueble) {
    //     update_post_meta($post_id, 'inmueble_garantia', sanitize_text_field($inmueble));
    // }
    if ($figura) {
        update_post_meta($post_id, 'figura', sanitize_text_field($figura));
    }
    $url = "";

    if ($baseURL){
        $url = $baseURL.get_post_field('post_name', $post_id);
    }

    if (!$url) {
        return new WP_Error('no_url', 'no hay url', array('status' => 400));
    }
   
    $sendMail = sendMailCreateProceso($email, $url, $titulo);

    if($sendMail){
        return new WP_REST_Response(array(
            'message' => 'Proceso creado, enviamos un correo',
            // 'data'      => $test,
            // 'slug'    => get_post_field('post_name', $post_id)
        ), 201);
    }

    // return new WP_REST_Response(array(
    //     'message' => 'Proceso creado',
    //     'id'      => $post_id,
    //     'slug'    => get_post_field('post_name', $post_id)
    // ), 201);
}

add_action('rest_api_init', function () {
    register_rest_route('wp/v2', '/createproceso', array(
        'methods'  => 'POST',
        'callback' => 'crear_proceso_endpoint',
        'permission_callback' => '__return_true'
    ));
});


// Endpoint para crear un nuevo documento
function crear_documento_endpoint(WP_REST_Request $request) {
    $parameters = $request->get_params();
    $titulo = $request->get_param('title');
    $slugProceso = $request->get_param('slugProceso');
    $nameDocumento = $request->get_param('nameDocumentoAFC');
    $tipo = $request->get_param('tipo');
    $tipoPersona = $request->get_param('tipoPersona');
    $idProceso = $request->get_param('idProceso');
    
    
  
    $nuevo_documento = array(
        'post_title'   => $titulo,
        'post_status'  => 'publish',
        'post_type'    => 'documento'
    );

    $post_id = wp_insert_post($nuevo_documento);


    if (is_wp_error($post_id)) {
        return new WP_Error('insert_error', 'Error al crear el documento', array('status' => 500));
    }
    $titulo = get_the_title($post_id);
    $update_data = [
        'ID'         => $post_id,
        'post_title' => $titulo . " - " . $post_id,
    ];
    wp_update_post($update_data);

    if ($slugProceso) {
        $proceso = get_page_by_path($slugProceso, OBJECT, 'proceso');
        $proceso_id = $proceso->ID;
        $monto = get_field('monto', $proceso_id);
        if($monto){
            update_field('monto_renta', $monto, $post_id);
        }


        if (is_wp_error($proceso_id)) {
            return new WP_Error('insert_error', 'No se encontro proceso', array('status' => 500));
        }

        $new_documentos = [$post_id]; // Nuevos IDs de publicaciones a agregar

        // Obtener los valores actuales del campo
        $current_documentos = get_post_meta($proceso_id, $nameDocumento, true);
        $hasDocumentAndExist = false;

        if(!empty($current_documentos)){
            // $postdocumento = get_post($current_documentos[0]);
            // if ($postdocumento && get_post_type($current_documentos[0]) === 'documento') {
            //     $hasDocumentAndExist = true;
            // }
            $args = [
                'post_type'   => 'documento',
                'p'           => $current_documentos[0], // ID del post
                'post_status' => 'publish'
            ];
            
            $query = new WP_Query($args);
            
            if ($query->have_posts()) {
                $hasDocumentAndExist = true;
            }
        }

  


        // Asegurar que es un array
        if ($hasDocumentAndExist) {
            return new WP_REST_Response(array(
                'message' => 'Ya existe documento asignado',
                'test' => $postdocumento
            ), 200);
        }
        // Agregar los nuevos valores evitando duplicados
        // $updated_documentos = array_unique(array_merge($current_documentos, $new_documentos));
  
        
        update_post_meta($proceso_id, $nameDocumento, $new_documentos);
    }

    if ($tipo) {
        update_post_meta($post_id, 'tipo', $tipo);
    }
    if ($tipoPersona) {
        update_post_meta($post_id, 'tipo_persona', $tipoPersona);
    }    
    if ($idProceso) {
        update_post_meta($post_id, 'proceso', $idProceso);
    }  

    

    return new WP_REST_Response(array(
        'message' => 'Documento creado',
        'id'      => $monto,
        'slug'    => get_post_field('post_name', $post_id)
    ), 201);
}

add_action('rest_api_init', function () {
    register_rest_route('wp/v2', '/createdocumento', array(
        'methods'  => 'POST',
        'callback' => 'crear_documento_endpoint',
        'permission_callback' => '__return_true'
    ));
});


function custom_generate_token_slug_documento($data, $postarr) {
    // Verifica que sea tu Custom Post Type
    if ($data['post_type'] === 'documento' && empty($postarr['ID'])) {
        // Genera un token aleatorio (ejemplo: 8 caracteres alfanuméricos)
        $token = substr(md5(uniqid(mt_rand(), true)), 0, 64);

        // Asegura que el slug sea único
        while (get_page_by_path($token, OBJECT, 'documento')) {
            $token = substr(md5(uniqid(mt_rand(), true)), 0, 64);
        }

        // Asigna el token como slug
        $data['post_name'] = $token;
    }

    return $data;
}
add_filter('wp_insert_post_data', 'custom_generate_token_slug_documento', 10, 2);

function update_documento_endpoint(WP_REST_Request $request) {
    $parameters = $request->get_params();
    $slugDocumento = $parameters['documento'];

    $documento = get_page_by_path($slugDocumento, OBJECT, 'documento');
    $documento_id = $documento->ID;

        
    if (!isset($documento_id)) {
        return new WP_REST_Response(array(
            'message' => 'Error: documento es requerido'
        ), 400);
    }

    unset($parameters['documento']); // Eliminamos post_id para que no se intente actualizar como ACF

    foreach ($parameters as $field_name => $value) {
        update_field($field_name, $value, $documento_id);
    }

    return new WP_REST_Response(array(
        'message' => 'Documento actualizado',
        'test' => $parameters
    ), 200);
}

add_action('rest_api_init', function () {
    register_rest_route('wp/v2', '/updatedocumento', array(
        'methods'  => 'POST',
        'callback' => 'update_documento_endpoint',
        'permission_callback' => '__return_true'
    ));
});


// Agregar un botón en el panel de administración solo para administradores
function agregar_boton_admin_documento() {
    // Verificamos si estamos editando un CPT de 'documento' y si el usuario tiene permisos de administrador
    if ('documento' === get_post_type() && current_user_can('administrator')) {
        // Agregamos el botón debajo del contenido de la caja de metadatos
        echo '<div class="misc-pub-section misc-pub-custom-button">';
        echo '<button type="button" id="mi_boton_admin" class="button">Generar documento</button>';
        echo '</div>';
    }
    if ('documento' === get_post_type() && current_user_can('administrator')) {
        // Agregamos el botón debajo del contenido de la caja de metadatos
        echo '<div class="misc-pub-section misc-pub-custom-button">';
        echo '<button type="button" id="mi_boton_admin_2" class="button">Generar documento Buro</button>';
        echo '</div>';
    }
}
add_action('post_submitbox_misc_actions', 'agregar_boton_admin_documento');


// Agregar un script para manejar el clic del botón
function agregar_script_admin_documento() {
    global $post;

    // Verificamos si estamos editando un CPT 'documento' y si el usuario es administrador
    if ('documento' === get_post_type($post) && current_user_can('administrator')) {
        ?>
        <script type="text/javascript">
            jQuery(document).ready(function($){
                const action = (buro = false) => {
                    var post_id = $('#post_ID').val(); // Obtener el ID del post actual
                    $.ajax({
                        url: ajaxurl,
                        type: 'POST',
                        data: {
                            action: 'ejecutar_metodo_boton_admin',
                            post_id: post_id,
                            buro: buro
                        },
                        success: function(response) {
                            if (response.success) {
                                alert(response.data.message);
                                
                                // window.location.href = response.data.file_url; // Descargar el archivo automáticamente
                                window.open(response.data.file_url, '_blank');
                            } else {
                                console.log(response)
                                alert('Error: ' + response.data.message);
                            }
                        },
                        error: function(error) {
                            console.log(error);
                            alert('Ocurrió un error al generar el documento.');
                        }
                    });
                }
                $('#mi_boton_admin').on('click', () => { action()});
                $('#mi_boton_admin_2').on('click', () => { action(true) });
            });

        </script>
        <?php
    }
}
add_action('admin_footer', 'agregar_script_admin_documento');

// Definir la acción que se ejecuta cuando se hace clic en el botón
function ejecutar_metodo_boton_admin() {
    $proceso_id = 0;
    $buro = false;

    if (isset($_POST['post_id'])) {
        $proceso_id = get_field('proceso', $_POST['post_id']);
    }

    if (isset($_POST['buro'])) {
        // $buro = $_POST['buro'];
        $buro = filter_var($_POST['buro'], FILTER_VALIDATE_BOOLEAN);

    }


    if (isset($_POST['post_id']) && current_user_can('administrator') && $proceso_id) {
        $post_id = intval($_POST['post_id']);
        // $file_url = generar_documento_word($post_id, $proceso_id);
        $file_url = generar_documento_word_pdf($post_id, $proceso_id, $buro);
        

        if ($file_url) {
            wp_send_json_success(['message' => 'Documento generado con éxito.', 'file_url' => $file_url]);
        } else {
            wp_send_json_error(['message' => 'Error al generar el documento.']);
        }
        wp_send_json_success(['message' => $_POST['post_id']]);
    } else {
        wp_send_json_error([
            'message' => 'No tienes permisos para realizar esta acción.',
            'a' => $campos_acf,
            'b' => $_POST['post_id'],
            'c' => $tipoo,
            'd' => error_log('Total encontrados: ' . $query->found_posts)
        ]);
    }
}


add_action('wp_ajax_ejecutar_metodo_boton_admin', 'ejecutar_metodo_boton_admin');





// function verificar_phpword() {
//     if (class_exists('PhpOffice\PhpWord\PhpWord')) {
//         echo "PHPWord está instalado correctamente.";
//     } else {
//         echo "PHPWord no está instalado.";
//     }
//     die();
// }

// add_action('init', 'verificar_phpword');



function generar_documento_word($post_id, $proceso_id) {
    // require_once ABSPATH . 'vendor/autoload.php'; // Asegúrate de que PHPWord está en esta ruta
    if (!class_exists('PhpOffice\PhpWord\TemplateProcessor')) {
        require_once get_template_directory() . '/vendor/autoload.php';
    }
    
    $poliza = [
        "basica" => "Básica",
        "premium" => "Premium",
        "elite" => "Élite",
        "hmas" => "H+"
    ];

    $nombreRecibo = [
        "pa50" => "50% y 50%, Propietario y arrendatario",
        "p100" => "100%, Propietario",
        "a100" => "100%, Arrendatario"
    ];
    
    $tipoPersona = get_field("tipo_persona", $post_id);
    $tipo = get_field("tipo", $post_id);

    $combinacion = $tipo . '-' . $tipoPersona;
    $templates = [
        'arrendador-fisica' => 'arrendador-persona-fisica.docx',
        'arrendador-moral' => 'arrendador-persona-moral.docx',
        'arrendatario-fisica' => 'arrendatario-persona-fisica.docx',
        'arrendatario-moral' => 'arrendatario-persona-moral.docx',
        'fiador-fisica' => 'fiador-persona-fisica.docx',
        'fiador-moral' => 'fiador-persona-moral.docx',
        'obligadoSolidario-fisica' => 'obligado-solidario-persona-fisica.docx',
        'obligadoSolidario-moral' => 'obligado-solidario-persona-moral.docx',
        'obligadoSolidario-moral' => 'obligado-solidario-persona-moral.docx',
    ];


    $template_path = get_template_directory() . '/plantillas'.'/'.$template_path = $templates[$combinacion] ?? 'arrendador-persona-fisica.docx'; // Ruta de la plantilla

    if (!file_exists($template_path)) {
        wp_send_json_error(['message' => 'No se encontró la plantilla']);
        return;
    }

    $campos_acf_proceso = [
        "poliza",
        "nombreRecibo"
    ];

    $campos_acf = [
        "razon_social",
        "nombre",
        "edad",
        "nacionalidad",
        "estado_civil",
        "ocupacion",
        "rfc",
        "curp",
        "telefono_fijo",
        "telefono_movil",
        "correo_electronico",
        "uso_inmueble",
        "domicilio",
        "colonia",
        "codigo_postal",
        "municipio",
        "estado",
        "domicilio_convencional",
        "colonia_convencional",
        "codigo_postal_convencional",
        "municipio_convencional",
        "estado_convencional",
        "monto_renta",
        "esMastraslacionrRetencionImpuestos",
        "monto_mantenimiento",
        "mantenimientoIncluidoRenta",
        "forma_pago_renta",
        "dias_pago_renta",
        "regimen_propiedad_condominio",
        "forma_pago_mantenimiento",
        "fecha_arrendamiento",
        "anos_arrendamiento",
        "deposito_garantia",
        "subarrendar",
        "mascotas",
        "lugares_estacionamiento",
        "condiciones_especiales",
        "institucion_bancaria",
        "nombre_titular",
        "cuenta",
        "cuenta_clabe",
        "cuenta_clabe_mantenimiento",
        "cuenta_mantenimiento",
        "nombre_titular_mantenimiento",
        "institucion_bancaria_mantenimiento",
        "mascotas_detalle",
        "referencia1_nombre",
        "referencia1_telefono",
        "referencia1_relacion",
        "referencia2_nombre",
        "referencia2_telefono",
        "referencia2_relacion",
        "referencia3_nombre",
        "referencia3_telefono",
        "referencia3_relacion",
        "referencia_ultimo_arrendador_nombre",
        "referencia_ultimo_arrendador_telefono",
        "referencia_ultimo_arrendador_domicilio",
        "habitantes",
        "empresa",
        "telefono_empresa",
        "domicilio_empresa",
        "rfc_2",
        "telefono_fijo_2",
        "telefono_movil_2",
        "correo_electronico_2",
        "giro_empresa",
        "actividad_cargo",
        "socio_empleado",
        "antiguedad",
        "ingresos_mensuales"
    ];



    $phpWord = new \PhpOffice\PhpWord\TemplateProcessor($template_path);

    foreach ($campos_acf_proceso as $campo) {
        $valor = get_field($campo, $proceso_id); // Obtener el valor de ACF
        if($campo == "poliza"){
            $valor = $poliza[$valor];
        }

        if($campo == "nombreRecibo"){
            $valor = $nombreRecibo[$valor];
        }
        if (!$valor) {
            $valor = ""; // Si el campo está vacío, poner un valor por defecto
        }

        $phpWord->setValue($campo, $valor); // Reemplazar en la plantilla
    }

    function evaluaFormaPago($valor, $campo) {
        return $valor;
    }

    foreach ($campos_acf as $campo) {
        $valor = get_field($campo, $post_id); // Obtener el valor de ACF

        if($campo == "mascotas"){
            $valor = $valor == "1" ? "Sí" : "No";
        }
        if($campo == "regimen_propiedad_condominio"){
            $valor = $valor == "1" ? "Sí" : "No";
        }
        if($campo == "subarrendar"){
            $valor = $valor == "1" ? "Sí" : "No";
        }

        if($campo == "institucion_bancaria"){
            $valor = evaluaFormaPago("Institución bancaria: ".$valor, "forma_pago_renta");
        }
        if($campo == "nombre_titular"){
            $valor = evaluaFormaPago("Nombre del titular: ".$valor, "forma_pago_renta");
        }
        if($campo == "cuenta"){
            $valor = evaluaFormaPago("Cuenta: ".$valor, "forma_pago_renta");
        }
        if($campo == "cuenta_clabe"){
            $valor = evaluaFormaPago("Cuenta CLABE: ".$valor, "forma_pago_renta");
        }


        if($campo == "institucion_bancaria_mantenimiento"){
            $valor = evaluaFormaPago("Institución bancaria: ".$valor, "forma_pago_mantenimiento");
        }
        if($campo == "nombre_titular_mantenimiento"){
            $valor = evaluaFormaPago("Nombre del titular: ".$valor, "forma_pago_mantenimiento");
        }
        if($campo == "cuenta_mantenimiento"){
            $valor = evaluaFormaPago("Cuenta: ".$valor, "forma_pago_mantenimiento");
        }
        if($campo == "cuenta_clabe_mantenimiento"){
            $valor = evaluaFormaPago("Cuenta CLABE: ".$valor, "forma_pago_mantenimiento");
        }

        if (!$valor) {
            $valor = ""; // Si el campo está vacío, poner un valor por defecto
        }

        $phpWord->setValue($campo, $valor); // Reemplazar en la plantilla
    }
   

    // Guardar el documento generado en la carpeta de uploads
    $upload_dir = wp_upload_dir();
    $file_path = $upload_dir['path'] . "/{$combinacion}_{$post_id}.docx";
    $file_url = $upload_dir['url'] . "/{$combinacion}_{$post_id}.docx";

    $phpWord->saveAs($file_path);

    // Devolver la URL del documento generado
    return $file_url;
}

function generar_documento_word_pdf($post_id, $proceso_id, $buro = false) {
    if (!class_exists('PhpOffice\PhpWord\TemplateProcessor')) {
        require_once get_template_directory() . '/vendor/autoload.php';
    }
    if (!class_exists('Dompdf\Dompdf')) {
        require_once get_template_directory() . '/vendor/autoload.php';
    }

    $poliza = [
        "basica" => "Básica",
        "premium" => "Premium",
        "elite" => "Élite",
        "hmas" => "H+"
    ];

    $nombreRecibo = [
        "pa50" => "50% y 50%, Propietario y arrendatario",
        "p100" => "100%, Propietario",
        "a100" => "100%, Arrendatario"
    ];

    $tipoPersona = get_field("tipo_persona", $post_id);
    $tipo = get_field("tipo", $post_id);
    $combinacion = $buro ? 'buro' : $tipo . '-' . $tipoPersona;

    $campos_acf_proceso = ["poliza", "nombreRecibo", "fecha"];
    $campos_acf = [
        "razon_social", "nombre", "edad", "nacionalidad", "estado_civil", "ocupacion", "rfc", "curp",
        "telefono_fijo", "telefono_movil", "correo_electronico", "uso_inmueble", "domicilio", "colonia",
        "codigo_postal", "municipio", "estado", "domicilio_convencional", "colonia_convencional",
        "codigo_postal_convencional", "municipio_convencional", "estado_convencional", "monto_renta",
        "esMastraslacionrRetencionImpuestos", "monto_mantenimiento", "mantenimientoIncluidoRenta",
        "forma_pago_renta", "dias_pago_renta", "regimen_propiedad_condominio", "forma_pago_mantenimiento",
        "fecha_arrendamiento", "anos_arrendamiento", "deposito_garantia", "subarrendar", "mascotas",
        "lugares_estacionamiento", "condiciones_especiales", "institucion_bancaria", "nombre_titular",
        "cuenta", "cuenta_clabe", "cuenta_clabe_mantenimiento", "cuenta_mantenimiento",
        "nombre_titular_mantenimiento", "institucion_bancaria_mantenimiento", "mascotas_detalle",
        "referencia1_nombre", "referencia1_telefono", "referencia1_relacion", "referencia2_nombre",
        "referencia2_telefono", "referencia2_relacion", "referencia3_nombre", "referencia3_telefono",
        "referencia3_relacion", "referencia_ultimo_arrendador_nombre", "referencia_ultimo_arrendador_telefono",
        "referencia_ultimo_arrendador_domicilio", "habitantes", "empresa", "telefono_empresa",
        "domicilio_empresa", "rfc_2", "telefono_fijo_2", "telefono_movil_2", "correo_electronico_2",
        "giro_empresa", "actividad_cargo", "socio_empleado", "antiguedad", "ingresos_mensuales", "email_autorizacion_buro_credito", "fecha_hora"
    ];

    // 🚨 Si es BURO → Generar PDF con DOMPDF
    if ($buro) {

        $upload_dir = wp_upload_dir();
        $output_file = $upload_dir['path'] . "/buro_{$post_id}.pdf";
        $output_url = $upload_dir['url'] . "/buro_{$post_id}.pdf";

        // Ruta a tu plantilla HTML (no PDF)
        $template_path = get_template_directory() . '/plantillas/buro-credito.html';

        if (!file_exists($template_path)) {
            wp_send_json_error(['message' => 'No se encontró la plantilla HTML para el PDF']);
            return;
        }

        $html_template = file_get_contents($template_path);

        // Obtener los valores
        $valores = [];
        foreach ($campos_acf_proceso as $campo) {
            $valor = get_field($campo, $proceso_id);
            if ($campo == "poliza") {
                $valor = $poliza[$valor] ?? $valor;
            }
            if ($campo == "nombreRecibo") {
                $valor = $nombreRecibo[$valor] ?? $valor;
            }
            if ($campo == "fecha") {
                $fechaHora = get_field("fecha_hora", $post_id);
                $partes = explode(' ', $fechaHora);
                $valor = $partes[0]; // Solo la fecha
            }
            $valores[$campo] = $valor ?: "";
        }

        foreach ($campos_acf as $campo) {
            $valor = get_field($campo, $post_id);
            if (in_array($campo, ["mascotas", "regimen_propiedad_condominio", "subarrendar"])) {
                $valor = $valor == "1" ? "Sí" : "No";
            }
            $valores[$campo] = $valor ?: "";
        }

        // Reemplazar variables en la plantilla {{campo}}
        foreach ($valores as $key => $value) {
            $html_template = str_replace('{{' . $key . '}}', $value, $html_template);
        }

        $options = new Options();
        $options->set('isRemoteEnabled', true);
        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html_template);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        file_put_contents($output_file, $dompdf->output());

        return $output_url;
    }

    // 📄 Si no es BURO → Usar PHPWord
    $templates = [
        'arrendador-fisica' => 'arrendador-persona-fisica.docx',
        'arrendador-moral' => 'arrendador-persona-moral.docx',
        'arrendatario-fisica' => 'arrendatario-persona-fisica.docx',
        'arrendatario-moral' => 'arrendatario-persona-moral.docx',
        'fiador-fisica' => 'fiador-persona-fisica.docx',
        'fiador-moral' => 'fiador-persona-moral.docx',
        'obligadoSolidario-fisica' => 'obligado-solidario-persona-fisica.docx',
        'obligadoSolidario-moral' => 'obligado-solidario-persona-moral.docx',
    ];

    $template_docx = $templates[$combinacion] ?? 'arrendador-persona-fisica.docx';
    $template_path = get_template_directory() . '/plantillas/' . $template_docx;

    if (!file_exists($template_path)) {
        wp_send_json_error(['message' => 'No se encontró la plantilla Word']);
        return;
    }

    $phpWord = new \PhpOffice\PhpWord\TemplateProcessor($template_path);

    foreach ($campos_acf_proceso as $campo) {
        $valor = get_field($campo, $proceso_id);
        if ($campo == "poliza") $valor = $poliza[$valor] ?? "";
        if ($campo == "nombreRecibo") $valor = $nombreRecibo[$valor] ?? "";
        $phpWord->setValue($campo, $valor ?: "");
    }

    foreach ($campos_acf as $campo) {
        $valor = get_field($campo, $post_id);

        if ($campo == "mascotas" || $campo == "regimen_propiedad_condominio" || $campo == "subarrendar") {
            $valor = $valor == "1" ? "Sí" : "No";
        }

        $phpWord->setValue($campo, $valor ?: "");
    }

    $upload_dir = wp_upload_dir();
    $file_path = $upload_dir['path'] . "/{$combinacion}_{$post_id}.docx";
    $file_url = $upload_dir['url'] . "/{$combinacion}_{$post_id}.docx";

    $phpWord->saveAs($file_path);

    return $file_url;
}


function ejecutar_metodo_boton_admin_external(WP_REST_Request $request) {
    $parameters = $request->get_params();
    $postId = $parameters['post_id'];
    $idProceso = $parameters['idProceso'];
    $buro = $parameters['buro'];
    
    if ($postId && $idProceso) { //&& current_user_can('administrator')
        $post_id = intval($postId);
        $proceso_id = intval($idProceso);
        $file_url = generar_documento_word_pdf($post_id, $proceso_id, $buro);

        if ($file_url) {
            wp_send_json_success(['message' => 'Documento generado con éxito.', 'file_url' => $file_url]);
        } else {
            wp_send_json_error(['message' => 'Error al generar el documento.']);
        }
        // wp_send_json_success(['message' => $post_id]);
    } else {
        wp_send_json_error([
            'message' => 'No tienes permisos para realizar esta acción.',
        ]);
    }
}


add_action('rest_api_init', function () {
    register_rest_route('wp/v2', '/generardocumento', array(
        'methods'  => 'POST',
        'callback' => 'ejecutar_metodo_boton_admin_external',
        'permission_callback' => '__return_true'
    ));
});

function sendMailPin($email, $pin, $texto){
    $data = [
        "pin" => $pin,
        "texto" => $texto,
        "urlimages" => get_template_directory_uri()
    ];
    $correos = [];
    array_push($correos, $email);
    try {
        $payload = json_encode($data);
        $url = get_template_directory_uri().'/mailtplCreatePin.php';
        $ch = curl_init();
        curl_setopt ($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
        curl_setopt($ch, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']);
        curl_setopt( $ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
        curl_setopt ($ch, CURLOPT_CONNECTTIMEOUT, 5);
        curl_setopt ($ch, CURLOPT_RETURNTRANSFER, true);
        $contents = curl_exec($ch);
        if (curl_errno($ch)) {
            echo curl_error($ch);
            echo "\n<br />";
            $contents = '';
        } else {
            curl_close($ch);
        }

        if (!is_string($contents) || !strlen($contents)) {
            // echo "Failed to get contents.";
            $contents = '';
        }
        $to = $correos;
        $subject = 'House Protect | Pin';
        $body = $contents;
        $headers = array('Content-Type: text/html; charset=UTF-8');
        $result = wp_mail($to, $subject, $body, $headers);
        return $result;
        return true;
    } catch (\Throwable $th) {
        return $th;
    }
}


function generate_and_send_pin(WP_REST_Request $request){
    $parameters = $request->get_params();
    $email = $parameters['email'];
    $time = $parameters['time'];
    $pin = 0;
    $texto = $parameters['textoEmail'];

    if($email){
        $pin = generate_temp_pin($email, $time);
    }

    if($pin){
        $sendMail = sendMailPin($email, $pin, $texto);
        if($sendMail){
            return new WP_REST_Response(array(
                'message' => 'Pin creado, enviamos un correo',
                // 'data'      => $test,
                // 'slug'    => get_post_field('post_name', $post_id)
            ), 201);
        }
    }else{
        return new WP_REST_Response(array(
            'message' => 'Error Al generar pin',
            // 'data'      => $test,
            // 'slug'    => get_post_field('post_name', $post_id)
        ), 200);
    }
    return new WP_REST_Response(array(
        'message' => 'Algo salio mal',
        // 'data'      => $test,
        // 'slug'    => get_post_field('post_name', $post_id)
    ), 200);
}

function generate_temp_pin($email, $timeSegundos = 900) {
    $pin = rand(100000, 999999);

    set_transient('pin_' . md5($email), $pin, $timeSegundos); // 15 min default
    set_transient('email_by_pin_' . $pin, $email, $timeSegundos);
    return $pin;
}

function validate_temp_pin($email, $input_pin) {
    $stored = get_transient('pin_' . md5($email));
    if ($stored && $stored == $input_pin) {
        delete_transient('pin_' . md5($email));
        delete_transient('email_by_pin_' . $input_pin);
        return true;
    }
    return false;
}

function validate_temp_pin_not_remove($pin) {
    $email = get_transient('email_by_pin_' . $pin);
    if ($email) {
        return $email;
    }
    return false;
}

function validate_temp_pin_not_remove_2($email, $input_pin) {
    $stored = get_transient('pin_' . md5($email));
    if ($stored && $stored == $input_pin) {
        return true;
    }
    return false;
}




add_action('rest_api_init', function () {
    register_rest_route('wp/v2', '/generatepin', array(
        'methods'  => 'POST',
        'callback' => 'generate_and_send_pin',
        'permission_callback' => '__return_true'
    ));
});



function autoriza_buro(WP_REST_Request $request) {
    $parameters = $request->get_params();
    $email = $request->get_param('email');
    $pin = $request->get_param('pin');

    $slugDocumento = $parameters['documento'];
    $documento = get_page_by_path($slugDocumento, OBJECT, 'documento');
    $documento_id = $documento->ID;
    $fecha = current_time('Y-m-d H:i:s');
    // $fecha = current_time('mysql');
    // $timezone = wp_timezone(); // zona horaria de WordPress
    // $datetime = new DateTime('now', $timezone);
    // $fecha = $datetime->format('Y-m-d H:i:s');


    if ($email && $pin && $documento_id) {
        if(validate_temp_pin($email, $pin)){
            update_post_meta($documento_id, 'email_autorizacion_buro_credito', sanitize_text_field($email));
            update_post_meta($documento_id, 'autorizo_buro_credito', true);
            update_post_meta($documento_id, 'fecha_hora', $fecha);
        }else{
            return new WP_REST_Response(array(
                'message' => 'Pin inválido',
            ), 200);
        }        
    }else{
        return new WP_Error('error', 'Falta pin o email', array('status' => 400));
    }




    return new WP_REST_Response(array(
        'message' => 'Autorización completa',
    ), 201);
}



add_action('rest_api_init', function () {
    register_rest_route('wp/v2', '/autorizaburo', array(
        'methods'  => 'POST',
        'callback' => 'autoriza_buro',
        'permission_callback' => '__return_true'
    ));
});





function valida_pin(WP_REST_Request $request) {
    $parameters = $request->get_params();
    $email = $request->get_param('email');
    $pin = $request->get_param('pin');
    if ($email && $pin) {        
        if(validate_temp_pin_not_remove_2($email, $pin)){

        }else{
            return new WP_REST_Response(array(
                'message' => 'Pin inválido',
            ), 200);
        }        
    }else{
        return new WP_Error('error', 'Falta pin o email', array('status' => 400));
    }


    return new WP_REST_Response(array(
        'message' => 'Autorización completa',
    ), 201);
}




add_action('rest_api_init', function () {
    register_rest_route('wp/v2', '/validatepin', array(
        'methods'  => 'POST',
        'callback' => 'valida_pin',
        'permission_callback' => '__return_true'
    ));
});


function get_data_procesos(WP_REST_Request $request) {
    $parameters = $request->get_params();
    $pin = $request->get_param('pin');

    if ($pin) {
        $email = validate_temp_pin_not_remove($pin);
        if ($email) {

            // Consulta a los posts tipo 'proceso' que tengan el ACF 'correo' igual al email
            $args = array(
                'post_type' => 'proceso',
                'posts_per_page' => -1,
                'post_status' => 'publish',
                'meta_query' => array(
                    array(
                        'key' => 'email', // nombre del campo ACF
                        'value' => $email,
                        'compare' => '='
                    )
                )
            );

            $query = new WP_Query($args);
            $procesos = array();

            if ($query->have_posts()) {
                while ($query->have_posts()) {
                    $query->the_post();
                    $post_id = get_the_ID();
                    $procesos[] = array(
                        'id' => $post_id,
                        'title' => get_the_title($post_id),
                        'last_updated' => get_the_modified_date('Y-m-d H:i:s', $post_id),
                        'fields' => get_fields($post_id), // <- Esto es más seguro
                        'slug' => get_post_field('post_name', $post_id),
                    );
                }
                wp_reset_postdata();
            }

            return new WP_REST_Response(array(
                'message' => 'Autorización completa',
                'data' => $email,
                'procesos' => $procesos
            ), 201);
        } else {
            return new WP_REST_Response(array(
                'message' => 'Pin inválido',
            ), 200);
        }
    } else {
        return new WP_Error('error', 'Falta pin', array('status' => 400));
    }
}




add_action('rest_api_init', function () {
    register_rest_route('wp/v2', '/getdataprocesos', array(
        'methods'  => 'POST',
        'callback' => 'get_data_procesos',
        'permission_callback' => '__return_true'
    ));
});



function generar_pdf_y_devolver_url($variables, $template_path, $filename = 'documento.pdf') {
    if (!class_exists('Dompdf\Dompdf')) {
        require_once __DIR__ . '/vendor/autoload.php'; // Ajusta ruta si es necesario
    }

    if (!file_exists($template_path)) {
        return new WP_Error('template_not_found', 'No se encontró la plantilla HTML.');
    }

    $html_template = file_get_contents($template_path);

    foreach ($variables as $key => $value) {
        $html_template = str_replace('{{' . $key . '}}', $value, $html_template);
    }

    $options = new Options();
    $options->set('isRemoteEnabled', true);

    $dompdf = new Dompdf($options);
    $dompdf->loadHtml($html_template);
    $dompdf->setPaper('A4', 'portrait');
    $dompdf->render();

    // Guardar PDF en uploads
    $upload_dir = wp_upload_dir();
    $upload_path = trailingslashit($upload_dir['basedir']) . $filename;

    file_put_contents($upload_path, $dompdf->output());

    // Devolver URL del PDF
    return trailingslashit($upload_dir['baseurl']) . $filename;
}




?>
